package newunits;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.unit.GUnit;

public class TestForNewUnits extends GPanel {
    
    private final GEntryReal widMol;
//    private final GEntryReal widDist;
    
    public TestForNewUnits () {
        
        final GUnit[] molUnits = { new MolUnit("mol"), new MolUnit("kmol") }; 
        widMol  = new GEntryReal("Mols:", 11., molUnits); // Initialization with 11 mol.

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(widMol);
    }

    public static void main(String[] args) {
        
        GFrame frame = new GFrame("MolUnits", new TestForNewUnits());
        frame.display();
        
    }

}
