package multipleObjects;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;

/**
 * Class to be tested reading multiple objects in a file.
 * @author goesterjf
 *
 */
public class VehicleData extends GPanel implements GListener, GReadWrite {
    
    /** List of units for mass */
    public static final GUnit[] UNITS_MASS = {new GMetricUnit("kg"), new GMetricUnit("t")};
    /** List of units for surface */
    public static final GUnit[] UNITS_SURFACE = {new GMetricUnit("m^2")};
    
    /** Main title */
    private final GLabel label;
    /** Widget for dry mass entry */
    private final GEntryReal dryMass;
    /** Widget for ergols mass entry */
    private final GEntryReal ergMass;
    /** Widget for reference area entry */
    private final GEntryReal sref;
    
    /**
     * Constructor.
     */
    public VehicleData () {
        
        super();
        
        label = new GLabel("Vehicle data");
        
        dryMass = new GEntryReal("Dry mass:", 0., UNITS_MASS);
        dryMass.setNameInConfigFile("dryMass");
        
        ergMass = new GEntryReal("Ergol mass:", 0., UNITS_MASS);
        ergMass.setNameInConfigFile("ergMass");
        
        sref = new GEntryReal("Reference surface:", 0., UNITS_SURFACE);
        sref.setNameInConfigFile("sref");
        
        this.setNameAndCommentInConfigFile("vehicle");
        
    }
    
    @Override
    public void attachCopyPasteMenu (String title, CopyPasteOperation... operationList) {
        label.attachCopyPasteMenu(title, operationList);
    }
    
    @Override
    public void generic() throws GException {
        beginOfElement("Vehicle", "vehicle");
        put(label);
        put(dryMass);
        put(ergMass);
        put(sref);
        endOfElement();
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void read() throws GException {
        generic();
    }

    @Override
    public void write() throws GException {
        generic();
    }

    @Override
    public void before(GEvent e) throws GException {
        // Nothing to do ...
    }

    @Override
    public void after(GEvent e) throws GException {

        // Needed to manage Paste functionality
        handleCopyPasteEvent(label, e);
        
    }

}
