package multipleObjects;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GMultipleStructureChoice;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GComponent;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;

/**
 * Class to test reading multiple objects in a file.
 * @author goesterjf
 *
 */
public class TestForMultipleObjects extends GPanel implements GListener, GReadWrite {
    
    /** Widget to visualize dry mass data when founded */
    private final GMultipleStructureChoice mscDryMass;
    /** GEntryReal widget for dry mass */
    private final GEntryReal dryMass;
    /** Widget to visualize vehicle data when founded */
    private final GMultipleStructureChoice mscVehicle;
    /** VehicleData widget */
    private final VehicleData vehicle;
    /** Button for selecting a XML file then searching inside it */
    private final GButton search;
    
    /**
     * Constructor.
     * @throws GException   GENIUS exception
     */
    public TestForMultipleObjects() throws GException {
        
        mscDryMass = new GMultipleStructureChoice("src/test/resources/TestForMultipleObjects.xml", new GEntryReal("dryMass", 0.), true);
        mscDryMass.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.height(150), GConstraint.spanx(2),
                GConstraint.pushx(), GConstraint.growx()));
                
        dryMass = new GEntryReal("Dry Mass:", 0., VehicleData.UNITS_MASS);
        dryMass.setNameInConfigFile("dryMass");
        dryMass.attachCopyPasteMenu(null, CopyPasteOperation.Paste);
        dryMass.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.split(4)), 0, 0);
        
        mscVehicle = new GMultipleStructureChoice("src/test/resources/TestForMultipleObjects.xml", new VehicleData(), true);
        mscVehicle.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.height(150), GConstraint.spanx(99),
                GConstraint.pushx(), GConstraint.growx()));
        
        vehicle = new VehicleData();
        vehicle.attachCopyPasteMenu(null, CopyPasteOperation.Paste);
        vehicle.setConstraint(new GConstraint(GConstraint.newline(true), GConstraint.spanx(99)));

        search = new GButton("Searching for VehicleData ...");
        search.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(2)));

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(mscDryMass);
        put(dryMass);
        put(mscVehicle);
        put(vehicle);
        put(search);
    }

    @Override
    public void read() throws GException {
        generic();
    }

    @Override
    public void write() throws GException {
        generic();
    }
    
    @Override
    public void before(GEvent arg0) throws GException {
        // TODO Auto-generated method stub
    }

    @Override
    public void after(GEvent arg0) throws GException {

        if ( arg0.contains(search) ) {
            
            final  JFileChooser ch = new JFileChooser(".");
            final FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files ...", "xml");
            ch.setFileFilter(filter);
            final int returnVal = ch.showOpenDialog(null);
            if ( returnVal == JFileChooser.APPROVE_OPTION ) {
                final String fileName = ch.getSelectedFile().getAbsolutePath();
                System.out.println("\nSearching for VehicleData in "+ fileName +" file ...");
                final List<GComponent> list = GFileManipulation.searchCompatibleComponents(fileName, new VehicleData(), true);
                System.out.println("Amount of compatible components: " + list.size());
                for ( GComponent comp : list ) {
                    System.out.println(comp.getGClassName());
                    System.out.println(comp.getPathInConfigFile());
                }
            }
            
        }

    }

    /**
     * Main method
     * @param args          no args needed ...
     * @throws GException   GENIUS exception
     */
    public static void main(String[] args) throws GException {
        
        final GFrame frame = new GFrame("TestForMultipleObjects", new TestForMultipleObjects());
        frame.display();

    }

}
