package multipleObjects;
import java.util.ArrayList;
import java.util.List;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GTree;
import fr.cnes.genius.lowLevel.GTree.GTreeNode;
import fr.cnes.genius.main.GComponent;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;

public class TestForGTree extends GPanel {
    
    private final GTree tree;
    
    private final GEntryReal real;
    private final GEntryInt integer;
    private final GEntryString string;
    
    public TestForGTree() {

        tree = new GTree("My Tree");
        
        real = new GEntryReal("Real", 99.99, new GUnit[] { new GMetricUnit("m") });
        integer = new GEntryInt("Integer", 1111);
        string = new GEntryString("String", "test");
        
        List<GComponent> componentsToAdd = new ArrayList<GComponent>();
        componentsToAdd.add(real);
        componentsToAdd.add(integer);
        tree.createNodes(componentsToAdd);
        
        GTreeNode parentNode = tree.getGTreeNode(tree.getRoot(), real);
        tree.addNode(parentNode, string);
        tree.expandAll();
        
        tree.setConstraint(new GConstraint(GConstraint.newline(true), GConstraint.width(200), GConstraint.height(150)));

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(tree);
    }

    public static void main(String[] args) {

        final GFrame frame = new GFrame("TestForGTree", new TestForGTree());
        frame.display();

    }

}
