package margins;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Sub class for GPanel margins test.
 * @author goesterjf
 *
 */
public class TestForMarginsPanel extends GPanel implements GListener {
    
	private GLabel lab;
    private GEntryInt marginTop;
    private GEntryInt marginBottom;
    private GEntryInt marginLeft;
    private GEntryInt marginRight;
	
	
	/**
	 * Constructor
	 */
	public TestForMarginsPanel( final String label, final int iniMargin ) {
	    
		lab = new GLabel(label);
        marginTop = new GEntryInt("top margin:", iniMargin);
        marginLeft = new GEntryInt("left margin:", iniMargin);
        marginBottom = new GEntryInt("bottom margin:", iniMargin);
        marginRight = new GEntryInt("right margin:", iniMargin);
        //this.setLayoutConstraints("insets "+iniMargin+" "+iniMargin+" "+iniMargin+" "+iniMargin);
        this.setMargins(iniMargin, iniMargin, iniMargin, iniMargin);

	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }

	/**
	 * Display method override.
	 */
	public void display() throws GException {
		put(lab);
        put(marginTop);
        put(marginLeft);
        put(marginBottom);
        put(marginRight);
	}
	
    @Override
    public void before(GEvent e) throws GException {
        // TODO Auto-generated method stub 
    }

    @Override
    public void after(GEvent e) throws GException {

        if ( e.contains(marginTop, marginLeft, marginBottom, marginRight)) {
            this.setLayoutConstraints("insets "+marginTop.getValue()+" "+marginLeft.getValue()+" "+marginBottom.getValue()+" "+marginRight.getValue());
        }
        
    }
    
}
