package margins;

import java.awt.Color;

import javax.swing.BorderFactory;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.constraints.GConstraint.YAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;

/**
 * Test for GPanel margins (FT 216)
 * @author goesterjf
 *
 */
public class TestForMargins extends GPanel {
    
    private TestForMarginsPanel pan1;
    private TestForMarginsPanel pan2;
    private TestForMarginsPanel pan3;
    private TestForMarginsPanel pan4;
    private GLabel labRight;
    private GLabel labBottom;
	
	/**
	 * Constructor
	 */
	public TestForMargins() {
	    
        pan1 = new TestForMarginsPanel("Pan1", 5);
        pan1.setConstraint(new GConstraint(GConstraint.newline(true)));
        pan1.getJPanel().setBorder(BorderFactory.createLineBorder(Color.BLACK));
        
        pan2 = new TestForMarginsPanel("Pan2", 20);
        pan2.getJPanel().setBorder(BorderFactory.createLineBorder(Color.BLACK));;
        pan2.setConstraint(new GConstraint(GConstraint.newline(false)));
        
        pan3 = new TestForMarginsPanel("Pan3", 0);
        pan3.getJPanel().setBorder(BorderFactory.createLineBorder(Color.BLACK));
        pan3.setConstraint(new GConstraint(GConstraint.newline(true)));
        
        pan4 = new TestForMarginsPanel("Pan4", 5);
        pan4.getJPanel().setBorder(BorderFactory.createLineBorder(Color.BLACK));;
        pan4.setConstraint(new GConstraint(GConstraint.newline(false)));
        
        labRight = new GLabel("Right border");
        labRight.setConstraint(new GConstraint(GConstraint.newline(false), GConstraint.aligny(YAlign.Center),
                GConstraint.spany(2),
                GConstraint.growx(), GConstraint.pushx()));
        
        labBottom = new GLabel("Bottom border");
        labBottom.setConstraint(new GConstraint(GConstraint.newline(true), GConstraint.alignx(XAlign.Center),
                GConstraint.spanx(2),
                GConstraint.growy(), GConstraint.pushy()));
	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }

	/**
	 * Display method override.
	 */
	public void display() throws GException {
		put(pan1);
        put(pan2);
        put(labRight);
        put(pan3);
        put(pan4);
        put(labBottom);
	}
	
	/**
	 * Main method
	 * @param args	no args ...
	 */
	public static void main(String[] args) {
		TestForMargins pan = new TestForMargins();
		pan.setConstraint(new GConstraint(GConstraint.newline()));
		GFrame frame = new GFrame("FT216TestForMargins", pan);	
		frame.display();
	}

}
