package gantt;

import java.util.Calendar;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;

public class TestGantt extends GPanel {
    
    private final GFreeChartGantt gantt;
    
    public TestGantt () {
        
        gantt = new GFreeChartGantt("mainTitle", "xAxis", "yAxisTitle", false);
        for (int i = 0; i < 3; i++) {
            final String label = "Item " + i;
            Calendar cal1 = Calendar.getInstance();
            cal1.set(2020, 1, i+1, 0, 0, 0);
            Calendar cal2 = Calendar.getInstance();
            cal2.set(2020, 1, i+1, 12, 0, 0);
            gantt.addTask(label, cal1.getTime(), cal2.getTime());
            
        }
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(gantt);
    }

    public static void main(String[] args) {

        TestGantt pan = new TestGantt();
        GFrame frame = new GFrame("Gantt", pan);    
        frame.display();
        
        
    }

}
