package UncaughtExceptions;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GDialog;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.main.GUncaughtExceptionHandler;

public class DialogUncaughtException implements GUncaughtExceptionHandler {
    
    public DialogUncaughtException () {
        super();
    }
    
    @Override
    public void uncaughtException(Throwable exception) {
        showException(exception);
    }
    
    /**
     * Method to show the error message
     * @param exception
     */
    private void showException (Throwable exception) {
    	
    	// We recover the original exception message
    	final String message = exception.getMessage();
        
    	/**
    	 * Internal class to build a GDialog object
    	 */
        final GDialog dialog = new GDialog("Error in the date format") {
           
            final private GLabel label = new GLabel(message);
        
            public void display() throws GException {
                generic();
            }
            @Override
            public void generic() throws GException {
                put(label);
            }
        };
    
        // We display the dialog window.
        try {
            dialog.show();
            dialog.dispose();
        } catch (GException e) {
            e.printStackTrace();
        }
          
    }

}
