
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GArithmeticException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GClear;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Test for default and saved values
 * @author goesterjf
 *
 */
public class TestForValues extends GPanel implements GClear, GListener {
	
	private GEntryString str;
	private GEntryInt ent;
	private GEntryReal val;
	private GCheckBox che;
	
    private GButton butClear;
    private GButton butSave;
	
	/**
	 * Constructor
	 * @throws GArithmeticException 
	 */
	public TestForValues() throws GArithmeticException {
	    
        butClear = new GButton("Clear");
        butClear.setConstraint(new GConstraint(GConstraint.newline(true), GConstraint.split(2)));
        butSave = new GButton("Save");
        butSave.setConstraint(new GConstraint(GConstraint.newline(false)));

		str = new GEntryString("Character string entry:", "text");
		str.setDefaultValue("default");
		str.setSavedValue("save");
		
		ent = new GEntryInt("Integer entry:", 123);
		ent.setDefaultValue(999);
		
		val = new GEntryReal("Real entry:", 99.);
		val.setDefaultValue(999.);
		
		che = new GCheckBox("Boolean");
		che.setSelected(true);
		che.setDefaultValue(false);
		
	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() throws GException {
	    
        put(butClear);
        put(butSave);
        
		put(str);
		put(ent);
		put(val);
		put(che);
		
}

	/**
	 * Display method override.
	 */
	public void display() throws GException {
	    generic();
	}
	
    @Override
    public void clear() throws GException {
        generic();
    }

    @Override
    public void before(GEvent e) throws GException {
    }

    @Override
    public void after(GEvent eve) throws GException {
        
        if ( eve.contains(butClear) ) {
            this.mainClear();
        }
        
    }

	/**
	 * Main method
	 * @param args	no args ...
	 * @throws GArithmeticException 
	 */
	public static void main(String[] args) throws GArithmeticException {
		TestForValues pan = new TestForValues();
		GFrame frame = new GFrame("TestForValues", pan);	
		frame.display();
	}

}
