

import fr.cnes.genius.exception.GEntryRealException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GCheckBoxWithIndicator;
import fr.cnes.genius.highLevel.GComboBoxWithLabel;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.interval.GIntervalAbstract.Rule;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.unit.GUnitFactory;

/**
 * Testing validity intervals
 * @author goesterjf
 *
 */
public class TestForValidityIntervals extends GPanel implements GListener {
    
    private static final double OK_MIN = Math.toRadians(30.);
    private static final double OK_MAX = Math.toRadians(60.);
    private static final Rule RULE_OK_MIN = Rule.INCLUSIVE;
    private static final Rule RULE_OK_MAX = Rule.EXCLUSIVE;
    private static final double WARN_MIN = Math.toRadians(0.);
    private static final double WARN_MAX = Math.toRadians(90.);
    private static final Rule RULE_WARN_MIN = Rule.INCLUSIVE;
    private static final Rule RULE_WARN_MAX = Rule.EXCLUSIVE;
	
    private final GCheckBoxWithIndicator cb;
	private final GEntryReal val;
	private final GComboBoxWithLabel combo;
	
    //private GUnit[] unitAngle = {new GMetricUnit("deg"), new GMetricUnit("rad")};
    private final GUnit[] unitAngle = GUnitFactory.getGUnitArray("deg", "rad");
	public final GInterval angleInterval;
	
	public TestForValidityIntervals() throws GIntervalException {
	    
	    cb = new GCheckBoxWithIndicator("Interval validity on angles;", true);
	    
	    angleInterval = new GInterval(OK_MIN, OK_MAX, RULE_OK_MIN, RULE_OK_MAX,
	            WARN_MIN, WARN_MAX, RULE_WARN_MIN, RULE_WARN_MAX);
		
		val = new GEntryReal("Angle entry:", Math.toRadians(45.), unitAngle);
		val.addGInterval(angleInterval);
		try {
			val.setFracDigits(10);
		} catch (GEntryRealException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		combo = new GComboBoxWithLabel("Combo", 1, "NONE", "Law 1", "Law 2");
		combo.setErrorLabelsList("NONE");
		combo.setWarningLabelsList("Law 2");

	}

	public void generic() { }

	public void display() throws GException {
        put(cb);
        put(val);
		put(combo);
	}
	
    @Override
    public void before (GEvent e) throws GException {
        // Nothing to do
    }

    @Override
    public void after (GEvent e) throws GException {
        
        if ( e.contains(cb) ) {
            if ( cb.isSelected() ) {
                System.out.println("selected ...");
                angleInterval.setOkMin(OK_MIN, false);
                angleInterval.setOkMinRule(RULE_OK_MIN, false);
                angleInterval.setWarnMin(WARN_MIN, false);
                angleInterval.setWarnMinRule(RULE_WARN_MIN, false);
                angleInterval.setOkMax(OK_MAX, false);
                angleInterval.setOkMaxRule(RULE_OK_MAX, false);
                angleInterval.setWarnMax(WARN_MAX, false);
                angleInterval.setWarnMaxRule(RULE_WARN_MAX, false);
            } else {
                System.out.println("not selected ...");
                angleInterval.setOkMax(Double.POSITIVE_INFINITY, false);
                angleInterval.setOkMaxRule(Rule.EXCLUSIVE, false);
                angleInterval.setWarnMax(Double.POSITIVE_INFINITY, false);
                angleInterval.setWarnMaxRule(Rule.EXCLUSIVE, false);
                angleInterval.setOkMin(Double.NEGATIVE_INFINITY, false);
                angleInterval.setOkMinRule(Rule.EXCLUSIVE, false);
                angleInterval.setWarnMin(Double.NEGATIVE_INFINITY, false);
                angleInterval.setWarnMinRule(Rule.EXCLUSIVE, false);
//                angleInterval.setWarnMinRule(Rule.EXCLUSIVE, false);
//                angleInterval.setWarnMin(Double.NEGATIVE_INFINITY, false);
//                angleInterval.setOkMinRule(Rule.EXCLUSIVE, false);
//                angleInterval.setOkMin(Double.NEGATIVE_INFINITY, false);
//                angleInterval.setWarnMaxRule(Rule.EXCLUSIVE, false);
//                angleInterval.setWarnMax(Double.POSITIVE_INFINITY, false);
//                angleInterval.setOkMaxRule(Rule.EXCLUSIVE, false);
//                angleInterval.setOkMax(Double.POSITIVE_INFINITY, false);
            }
            angleInterval.checkInterval();
            val.updateStatus();
            
            System.out.println(angleInterval.getWarnMin());
            System.out.println(angleInterval.getWarnMax());
            System.out.println(angleInterval.getOkMin());
            System.out.println(angleInterval.getOkMax());
            
        }
        
    }

	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForValidityIntervals pan = new TestForValidityIntervals();
		GFrame frame = new GFrame("TestForValidityIntervals", pan);	
		frame.display();
	}

}
