import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import org.jdom.Element;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.highLevel.GCheckBoxWithIndicator;
import fr.cnes.genius.highLevel.GChoice;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

public class TestForUnknownData extends GPanel implements GReadWrite {
    
    private final GCheckBoxWithIndicator widCb;
    private final GChoice widChoice;
    
    public enum choices {
        C1, C2, C3
    }
    
    public TestForUnknownData() {
        
        widCb = new GCheckBoxWithIndicator("Cb:", false);
        widCb.setNameInConfigFile("cb");
        widChoice = new GChoice("", "Choice:", choices.C2);
        widChoice.setNameInConfigFile("choice");
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void read() throws GException {
        
        try {
            final Element read = GFileManipulation.findElement(this.getElement(), ItemType.Boolean, "name",
                    widCb.getNameInConfigFile(), null);
        } catch ( GFileManipulatorException err ) {
            System.out.println("Data not read ...");
        }

        generic();
        
    }

    @Override
    public void write() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(widCb);
        put(widChoice);
    }

    public static void main(String[] args) throws IOException {
        
        final File refFile = new File("src/test/resources/UnknownData.xml");
        final File locFile = new File("UnknownData.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        //final GFrame frame = new GFrame("TestForGChoice", new TestForUnknownData());
        final GPanTest frame = new GPanTest("TestForUnknownData", new TestForUnknownData(), "UnknownData.xml");

        frame.display();
        
    }

}
