import java.util.ArrayList;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GArithmeticException;
import fr.cnes.genius.exception.GDateFieldException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GChoice;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryRealVector;
import fr.cnes.genius.highLevel.GListSelect;
import fr.cnes.genius.highLevel.GSliderRealWithLabel;
import fr.cnes.genius.highLevel.GSliderWithLabel;
import fr.cnes.genius.highLevel.GTable1D;
import fr.cnes.genius.highLevel.GTable1D.TableOrientation;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GTime;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GTemperatureUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.unit.GUnitFactory;
import fr.cnes.genius.utils.GDateUtils.GDateFormat;

public class TestForUnitsPosition extends GPanel {
    
    private final GChoice widChoice;
    private final GEntryReal widDistance;
    private final GEntryReal widDurationAsReal;
    private final GTime widDuration;
    private final GEntryRealVector entryVectorWithUnit;
    private final GTable1D widTable;
    private final GListSelect widList;
    private final GSliderWithLabel widSliderInt;
    private final GSliderRealWithLabel widSliderReal;
    
    private static final double[] m_realVectorWithUnit = { -100.0E4, -200.0E5, -300.0E6 };
    
    private static final GUnit[] m_tempUnit = { new GTemperatureUnit("°C"), new GTemperatureUnit("K"), new GTemperatureUnit("°F") };
    
    public TestForUnitsPosition () throws GDateFieldException, GArithmeticException {
        
        widChoice = new GChoice("Choice:", 0, "First choice", "Second choice", "Third choice");
        
        final GUnit[] unitDis = GUnitFactory.getGUnitArray("km", "nmi");
        widDistance  = new GEntryReal("Distance", 1000., unitDis); // Initialization with 1000 meters.

        final GUnit[] unitDur = GUnitFactory.getGUnitArray("s", "j", "d", "mo", "a", "y");
        widDurationAsReal  = new GEntryReal("Duration as real:", 365.25*86400., unitDur); // Initialization with 1 year.
        
        widDuration = new GTime("Duration :", 30000.00);
        widDuration.setUnit(new GMetricUnit("s"));
        widDuration.setCurrentFormat(GDateFormat.Fraction);
        
        entryVectorWithUnit = new GEntryRealVector(
            "<html>Real Vector<br>&sigma;with unit<html>", m_realVectorWithUnit, m_tempUnit);
        widTable = new GTable1D("m_table", "Test Table", TableOrientation.VERTICAL,
                        entryVectorWithUnit);
        widTable.setCommentInConfigFile("Comment for the GTable1D.");
        widTable.setColumnConstraints("[130::]10[130::]10[130::]");
        widTable.setConstraint(new GConstraint(GConstraint.newline()));
        
        final int dim = 30;
        final ArrayList<String> listOfData = new ArrayList<String>(dim);
        for (int i = 0; i < dim; i++) {
            listOfData.add(String.format("%s%03d", "VAR", i));
        }
        widList = new GListSelect(listOfData);
        
        // Create table
        widSliderInt = new GSliderWithLabel("Horizontal integer slider:", "HORIZONTAL", -20, 20, 0, 5);
        
        widSliderReal = new GSliderRealWithLabel("Horizontal real slider:", "HORIZONTAL", -100.0, 100.0, 0.0, 20.0, 1, unitDur);
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(widChoice);
        put(widDistance);
        put(widDurationAsReal);
        put(widSliderInt);
        put(widDuration);
        put(widList);
        put(widSliderReal);
        put(widTable);
    }

    public static void main(String[] args) throws GDateFieldException, GArithmeticException {
        
        GFrame frame = new GFrame("Units", new TestForUnitsPosition());
        frame.display();
        
    }

}
