import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.unit.GUnitFactory;
import fr.cnes.genius.utils.GPanTest;

public class TestForUnitsConversion extends GPanel implements GReadWrite, GListener {
    
    private final GEntryReal dist;
    private final GButton butDisplay;
    
    public TestForUnitsConversion () {
        
        final GUnit[] unitVel = GUnitFactory.getGUnitArray("km/s", "m/s");
        dist  = new GEntryReal("Distance", 0., unitVel);
        
        butDisplay = new GButton("Display");

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(dist);
        put(butDisplay);
    }

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

    @Override
    public void before (GEvent e) throws GException {
    }

    @Override
    public void after (GEvent e) throws GException {
        if ( e.contains(butDisplay) ) {
            System.out.println(dist.getValue());
        }
    }

    public static void main(String[] args) throws IOException {
        
        final File refFile = new File("src/test/resources/UnitsConversionPrecision.xml");
        final File locFile = new File("UnitsConversionPrecision.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        GPanTest frameTest = new GPanTest("Units conversion precision", new TestForUnitsConversion(), "UnitsConversionPrecision.xml");
        frameTest.display();
    }

}
