import java.math.BigDecimal;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.unit.GByteUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.unit.GUnitFactory;
import fr.cnes.genius.utils.GPanTest;

public class TestForUnitsBytes extends GPanel implements GReadWrite {
    
    private final GEntryReal bytes;
    
    public TestForUnitsBytes () throws GException {
        
        final GUnit[] unitBytes = GUnitFactory.getGUnitArray("Ko", "Mo", "Go");
        bytes  = new GEntryReal("Heap space", 1024, unitBytes); // Initialization with 1 Ko

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(bytes);
    }

    public static void main(String[] args) throws GException {
        
        final GByteUnit uk = new GByteUnit("Ko");
        final GByteUnit um = new GByteUnit("Mo");
        final GByteUnit ug = new GByteUnit("Go");
        
        System.out.println();
        System.out.println("convertFromMemory (double/BigDecimal) ...");
        System.out.println("1024 Ko in Ko:   " + uk.convertFromMemory(1024.) + " / " + uk.convertFromMemory(new BigDecimal(1024.)));
        System.out.println("1024^2 Ko in Mo: " + um.convertFromMemory(1024.*1024.) + " / " + um.convertFromMemory(new BigDecimal(1024.*1024.)));
        System.out.println("1024^3 Ko in Go: " + ug.convertFromMemory(1024.*1024.*1024.) + " / " + ug.convertFromMemory(new BigDecimal(1024.*1024.*1024.)));

        System.out.println();
        System.out.println("convertToMemory (double/BigDecimal) ...");
        System.out.println("1024 Ko:   " + uk.convertToMemory(1024.) + " / " + uk.convertToMemory(new BigDecimal(1024.)));
        System.out.println("1 Mo:      " + um.convertToMemory(1.) + " / " + um.convertToMemory(new BigDecimal(1.)));
        System.out.println("1/1024 Go: " + ug.convertToMemory(1./1024.) + " / " + ug.convertToMemory(new BigDecimal(1./1024.)));

        System.out.println();
        System.out.println("convertToUnit (double/BigDecimal) ...");
        System.out.println("1024 Ko in Ko:   " + uk.convertToUnit(1024., uk) + " / " + uk.convertToUnit(new BigDecimal(1024.), uk));
        System.out.println("1024 Ko in Mo:   " + uk.convertToUnit(1024., um) + " / " + uk.convertToUnit(new BigDecimal(1024.), um));
        System.out.println("1024 Ko in Go: " + uk.convertToUnit(1024., ug) + " / " + uk.convertToUnit(new BigDecimal(1024.), ug));
        System.out.println("1 Mo in Ko:   " + um.convertToUnit(1., uk) + " / " + um.convertToUnit(new BigDecimal(1.), uk));
        System.out.println("1 Mo in Mo:   " + um.convertToUnit(1., um) + " / " + um.convertToUnit(new BigDecimal(1.), um));
        System.out.println("1 Mo in Go:   " + um.convertToUnit(1., ug) + " / " + um.convertToUnit(new BigDecimal(1.), ug));
        System.out.println("1 Go in Ko:   " + ug.convertToUnit(1., uk) + " / " + ug.convertToUnit(new BigDecimal(1.), uk));
        System.out.println("1 Mo in Mo:   " + ug.convertToUnit(1., um) + " / " + ug.convertToUnit(new BigDecimal(1.), um));
        System.out.println("1 Go in Go:   " + ug.convertToUnit(1., ug) + " / " + ug.convertToUnit(new BigDecimal(1.), ug));

        GPanTest frame = new GPanTest("Bytes Units", new TestForUnitsBytes(), "BytesUnits.xml");
        frame.display();
        
    }

}
