import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.unit.GUnitFactory;

public class TestForUnits extends GPanel {
    
    private final GEntryReal dist;
    private final GEntryReal duration;
    
    public TestForUnits () {
        
        final GUnit[] unitDis = GUnitFactory.getGUnitArray("km", "nmi");
        dist  = new GEntryReal("Distance", 1000., unitDis); // Initialization with 1000 meters.

        final GUnit[] unitDur = GUnitFactory.getGUnitArray("s", "j", "d", "mo", "a", "y");
        duration  = new GEntryReal("Duration", 365.25*86400., unitDur); // Initialization with 1 year.

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(dist);
        put(duration);
    }

    public static void main(String[] args) {
        GFrame frame = new GFrame("Units", new TestForUnits());
        frame.display();
    }

}
