/**
* HISTORIQUE
* FIN-HISTORIQUE
*/


import java.awt.Dimension;
import java.io.IOException;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEnvironment;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.utils.GPanTest;

/**
 * Test class to run manually via the main to verify the working principle of the method
 * {@link GEnvironment#saveLogToFile(String)}.
 * 
 * The test is designed so that a copy of the log file is produced when the user enters the value 2.0 to the value
 * altitude in the panel test.
 * 
 * @author Nicola NATALE
 *
 */
public class TestForSaveLogfile extends GPanel implements GReadWrite, GListener {

    /** Altitude value to manage the copy of the log file */
    private final GEntryReal altitude;

    /** Unit lists to be used for the altitude */
    private final GUnit[] unitList = { new GMetricUnit("m") };

    public TestForSaveLogfile() {
        super();
        altitude = new GEntryReal("altitude_widget", "altitude", 1., unitList);
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void before(GEvent e) throws GException {

    }

    @Override
    public void after(GEvent e) throws GException {
        if (e.contains(altitude)) {
            // Verify the value provided by the user for the altitude and make a copy of the log file eventually
            if (altitude.getValue() == 2.0) {
                try {
                    GEnvironment.saveLogToFile("copyOfLog.log");
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    @Override
    public void read() throws GException {
        generic();

    }

    @Override
    public void write() throws GException {
        generic();

    }

    @Override
    public void generic() throws GException {
        put(altitude);
    }

    /**
     * Launch the test case with the given panel displaying the altitude to be modified by the user to make a copy of
     * the log file.
     * 
     * @param args
     * @throws GException
     */

    public static void main(String[] args) throws GException {
        // Set the initial log file name
        GEnvironment.setLogFilename("GSaveLogfileTest_0601.log", false);
        // Initialise the panel for test together with the dedicated properties
        final TestForSaveLogfile testWidget = new TestForSaveLogfile();
        final GPanTest frameTest = new GPanTest("GSaveLogfileTest_0601", testWidget);
        frameTest.setMinimumSize(new Dimension(200, 100));
        frameTest.display();
    }

}
