import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GArithmeticException;
import fr.cnes.genius.exception.GDateFieldException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GChoice;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.interval.GIntervalAbstract.GStatus;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GTime;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

public class TestForGTime extends GPanel implements GReadWrite, GListener {
    
    private final GTime time;
    private final GChoice cb;
    
    public TestForGTime () throws GDateFieldException, GArithmeticException {
        
        time  = new GTime("time:");
        time.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(false),  GConstraint.width(200)),1);
        try {
            time.addGInterval(new GInterval(0., 3600.));
        } catch ( GIntervalException e ) {
            // Will never occur
        }
        time.setDuration(0.);
        //time.setDefaultDuration(1800.);
        time.setDefaultDuration("30m");
        
        cb = new GChoice("", "Forced in error:", GStatus.OK);
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        try {
            put(time);
        } catch ( Exception e ) {
            e.printStackTrace();
        }
        put(cb);
    }

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

    @Override
    public void before (GEvent e) throws GException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void after (GEvent e) throws GException {

        if ( e.contains(cb) ) {
            final GStatus status = (GStatus)cb.getValueEnum();
            if ( status == GStatus.WARN || status == GStatus.ERROR ) {
                time.setForcedStatus(status);
            } else {
                time.setForcedStatus(null);
            }
            time.updateStatus();            
        }
        
    }

    public static void main(String[] args) throws GDateFieldException, GArithmeticException, IOException {
        
        final File refFile = new File("src/test/resources/GTime.xml");
        final File locFile = new File("GTime.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        final GPanTest panTest = new GPanTest("GTime", new TestForGTime(),"GTime.xml");
        panTest.display();

        
    }

}
