import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GTabbedPane;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

/**
 * Testing GTabbedPane and tooltips
 * @author goesterjf
 *
 */
public class TestForGTabbedPaneAndToolTip extends GPanel implements GReadWrite {
	
	GTabbedPane tabs;
	
	GLabel lab1;
	GLabel lab2;
    GLabel lab3;
    GLabel lab4;
	
	GEntryInt valI3;
    GEntryReal valR3;
    GEntryReal valR4;
	
	public TestForGTabbedPaneAndToolTip () throws GException {
		
		tabs = new GTabbedPane("Tabbedpane");
		tabs.setConstraint(new GConstraint(GConstraint.grow(), GConstraint.push()));

		lab1 = new GLabel("Tab 1 ...");
		lab2 = new GLabel("Tab 2 ...");
        lab3 = new GLabel("Tab 3 ...");
        lab4 = new GLabel("Tab 4 ...");
		
		valI3 = new GEntryInt("Integer :", 123);
		valI3.setToolTipText("This is an integer");
		valI3.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(50), GConstraint.split(2)), 0, 0);
		valI3.setInnerDescendantConstraint(new GConstraint(GConstraint.gaptop(50)), 1);
        valR3 = new GEntryReal("Real :", 3.14);
        valR3.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(50), GConstraint.split(2)), 0, 0);
        valR3.setInnerDescendantConstraint(new GConstraint(GConstraint.gaptop(50)), 1);
        valR3.setToolTipText("This is another real");
        valR4 = new GEntryReal("Real :", 9.99);
        valR4.setDefaultValue(9.99);
        valR4.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(50), GConstraint.split(2)), 0, 0);
        valR4.setInnerDescendantConstraint(new GConstraint(GConstraint.gaptop(50)), 1);
        valR4.setToolTipText("This is another real");
	
		tabs.addTab("Tab 1", new GPanel() {
			public void display() throws GException { generic(); }
			@Override
			public void generic() throws GException { put(lab1); }

		});
		
		tabs.addTab("Tab 2", new GPanel() {
			public void display() throws GException { generic(); }
			@Override
			public void generic() throws GException { put(lab2); }
		});
		
        tabs.addTab("Tab 3", new Pan3());
        tabs.addTab("Tab 4", new Pan4());
		
		tabs.getJTabbedPane().setSelectedIndex(1);
		tabs.getJTabbedPane().setEnabledAt(0, false);
		
	}

	public void display() throws GException { generic(); }

	@Override
	public void generic() throws GException {
		put(tabs);
	}
	
	public void read() throws GException { generic(); }

	public void write() throws GException { generic(); }
	
    private class Pan3 extends GPanel implements GReadWrite {
        public void display() throws GException { generic(); }
        @Override
        public void generic() throws GException {
            put(lab3);
            put(valI3);
            put(valR3);
            }
        @Override
        public void read () throws GException {generic(); }
        @Override
        public void write () throws GException { generic(); }
    }

    private class Pan4 extends GPanel implements GReadWrite {
        public void display() throws GException { generic(); }
        @Override
        public void generic() throws GException {
            put(lab4);
            put(valR4);
            }
        @Override
        public void read () throws GException {generic(); }
        @Override
        public void write () throws GException { generic(); }
    }

	/**
	 * @param args
	 * @throws GException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws GException, IOException {

        final File refFile = new File("src/test/resources/TestForGTabbedPaneAndToolTip.xml");
        final File locFile = new File("TestForGTabbedPaneAndToolTip.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

		TestForGTabbedPaneAndToolTip test = new TestForGTabbedPaneAndToolTip();

		GPanTest panTest = new GPanTest("TestForGTabbedPaneAndToolTip", test, "TestForGTabbedPaneAndToolTip.xml");
		panTest.getJFrame().setPreferredSize(new Dimension(800, 450));

		panTest.display();


	}

}
