
import java.awt.Dimension;

import fr.cnes.genius.chart.GFreeChartXY.GFreeChartXYItem;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GMenu;
import fr.cnes.genius.highLevel.GMenuBar;
import fr.cnes.genius.highLevel.GMenuItem;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.plots.GPlotPanel;
import fr.cnes.genius.utils.GContextFileManagement;
import fr.cnes.genius.utils.GFileFilter;

/**
 * Testing GPlotPanel
 * @author goesterjf
 *
 */
public class TestForGPlotPanel extends GPanel implements GListener, GReadWrite {
	
    private GMenuItem itemLoad;
    private GMenuItem itemSave;
    private GMenu fileMenu;
    private GMenuBar bar;
    
    private GContextFileManagement gfm;

    private final GPlotPanel plots;
	
	public TestForGPlotPanel() throws GIntervalException {
	    
	    // Item of File Menu initialization
        itemLoad = new GMenuItem("Load ...");
        itemSave = new GMenuItem("Save ...");

        // FileMenu initialization
        fileMenu = new GMenu("File");
        fileMenu.add(itemLoad);
        fileMenu.add(itemSave);

        // Menu Bar initialization
        bar = new GMenuBar(this);
        bar.add(fileMenu);

        // GContextFileManagement object initialization
        gfm = new GContextFileManagement( ".", "GPlotContext", new GFileFilter("GPLOT_", ".xml", "GPlot context Files") );

        //plots = new GPlotPanel("EPH", "", "Ephemeris file", 2, true, new GPlotDataMadonaReader(), true);
        //plots = new GPlotPanel("", "", "Ephemeris file", 2, true, new GPlotDataSqliteReader(), true);
        //plots = new GPlotPanel("", "", "Ephemeris file", 2, true);
        plots = new GPlotPanel("EPH", "", "Ephemeris file", 2, true, null, false);
        plots.setNameInConfigFile("plots");
        plots.setCalculatorMode(true);
	}

	public void generic() throws GException {
		put(plots);
	}

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

	public void display() throws GException {
		generic();
	}
	
    @Override
    public void before(GEvent e) throws GException {
    }

    @Override
    public void after(GEvent e) throws GException {
        
        if ( e.contains(itemLoad) ) {
            gfm.selectLoadFile(this, false);
        }
        if ( e.contains(itemSave) ) { gfm.selectSaveFile(this, true); }
        
        if ( (e.getFinalSource() == plots.getGFreeChartXY()) && plots.isDisplayingSerie() ) {
            
            final GFreeChartXYItem coordsAbsMain = plots.getPlaneCoordinates(false);
            if ( coordsAbsMain != null ) {
                System.out.println("Absolute main coordinates: "+coordsAbsMain.getStrX()+" / "+coordsAbsMain.getStrY());            
            }
            
            final GFreeChartXYItem coordsAbsMainSecond = plots.getPlaneCoordinates(true);
            if ( coordsAbsMainSecond != null ) {
                System.out.println("Absolute relative coordinates: "+coordsAbsMainSecond.getStrX()+" / "+coordsAbsMainSecond.getStrY());
            }
            
            final GFreeChartXYItem coordsMain = plots.getItemCoordinates();
            if ( coordsMain != null ) {
                System.out.println("Serie: "+coordsMain.getSeriesName());
                System.out.println("Index in the serie: "+coordsMain.getIndex());
                System.out.println("Position: "+coordsMain.getStrX()+" / "+coordsMain.getStrY());
            } else {
                System.out.println("Too far from a point ...");
            }
            
        }
    }
	
    public GMenuBar getBar() { return bar; }

	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForGPlotPanel pan = new TestForGPlotPanel();
		GFrame frame = new GFrame("TestForGPlotPanel", pan, pan.getBar());	
		frame.setPreferredSize(new Dimension(800, 650));
		frame.display();
	}

}
