import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GMultipleChoice;
import fr.cnes.genius.interval.GIntervalAbstract.GStatus;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

public class TestForGMultipleChoice extends GPanel implements GListener{
    
    private final GMultipleChoice choice;
    
    public TestForGMultipleChoice() {
        
        final int[] tabChoiceSelect = { 0, 2 };
        final String[] tabChoiceLabels = { "a", "b", "cb", "d" };
        choice = new GMultipleChoice("Choice:", tabChoiceSelect, tabChoiceLabels);
        choice.setStatusMessages("That's OK.", "Two choices will be better ...", "At least one choice must be selected !");
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(choice);
    }

    @Override
    public void before (GEvent e) throws GException {
        // Nothing to do
    }

    @Override
    public void after (GEvent e) throws GException {

        if ( e.contains(choice) ) {
            final int[] select = choice.getSelectedValues();
            if ( select.length == 0 ) {
                choice.setForcedStatus(GStatus.ERROR);
            } else if ( select.length == 1 ){
                choice.setForcedStatus(GStatus.WARN);
            } else {
                choice.setForcedStatus(GStatus.OK);
            }
            choice.updateStatus();
        }
        
    }

    public static void main(String[] args) {

        final GFrame frame = new GFrame("TestForGMultipleChoice", new TestForGMultipleChoice());
        frame.display();
        
    }

}
