import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GMenu;
import fr.cnes.genius.highLevel.GMenuBar;
import fr.cnes.genius.highLevel.GMenuItem;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GContextFileManagement;
import fr.cnes.genius.utils.GFileFilter;

/**
 * Testing Menu Bar and Context Files Management as well as Shortcuts
 * @author goesterjf
 *
 */
public class TestForGMenuBarAndGContextFileManagement extends GPanel implements GReadWrite, GListener {
	
	private GMenuItem itemLoad;
	private GMenuItem itemSave;
	private GMenuItem itemQuit;
	
	private GMenuItem itemHelp;
	
	private GMenu level0Menu;
	private GMenu level1Menu;
	private GMenuItem itemLevel11;
	private GMenuItem itemLevel12;
	
	private GMenu fileMenu;
	private GMenu aboutMenu;
	
	private GMenuBar bar;
	
	private GEntryReal valR;
	private GEntryInt  valI;
	
	private GContextFileManagement gfm;
	
	public TestForGMenuBarAndGContextFileManagement () {
		
		// Item of File Menu initialization
		itemLoad = new GMenuItem("Load ...");
		itemLoad.setShortcut(KeyEvent.VK_L);
		itemLoad.setAccelerator(KeyEvent.VK_L, ActionEvent.CTRL_MASK);
		itemSave = new GMenuItem("Save ...");
		itemSave.setShortcut(KeyEvent.VK_S);
		itemSave.setAccelerator(KeyEvent.VK_S, ActionEvent.CTRL_MASK);
		itemQuit = new GMenuItem("Quit");
		itemHelp = new GMenuItem("?");
		
		// FileMenu initialization
		fileMenu = new GMenu("File");
		fileMenu.add(itemLoad);
		fileMenu.add(itemSave);
		fileMenu.add(itemQuit);
		fileMenu.setShortcut(KeyEvent.VK_M);
		
		// FileMenu initialization
		aboutMenu = new GMenu("About");
		aboutMenu.add(itemHelp);

		level1Menu = new GMenu("level 1");
		itemLevel11 = new GMenuItem("level 1-1");
		itemLevel12 = new GMenuItem("level 1-2");
		level1Menu.add(itemLevel11);
		level1Menu.add(itemLevel12);
		
		// FileMenu initialization
		level0Menu = new GMenu("Level 0");
		level0Menu.add(level1Menu);

		// Menu Bar initialization
		bar = new GMenuBar(this);
		bar.add(fileMenu);
		bar.add(aboutMenu);
		bar.add(level0Menu);
		
		// Data initialization
		valR = new GEntryReal("Real Value", 123.);
		valR.setNameInConfigFile("valR");
		valI = new GEntryInt("Integer value", 1);
		valI.setNameInConfigFile("valI");
		
		// GContextFileManagement object initialization
		gfm = new GContextFileManagement( ".", "Test", new GFileFilter("TEST_", ".xml", "Test Files") );
		
	}

	public GMenuBar getBar() { return bar; }

	public void read() throws GException { generic(); }

	public void write() throws GException { generic(); }

	public void display() throws GException { generic(); }

	public void generic() throws GException {
	    beginOfElement("StrTest", "test");
		put(valR);
		put(valI);
		endOfElement();
		}
	
	@Override
	public void after(GEvent e) throws GException {
		
		if ( e.contains(itemLoad) ) {
		    gfm.selectLoadFile(this, false);
		    }
		if ( e.contains(itemSave) ) { gfm.selectSaveFile(this, true); }
		if ( e.contains(itemLevel11) ) { System.out.println("Level 1-1 !"); }
		if ( e.contains(itemLevel12) ) { System.out.println("Level 1-2 !"); }
		if ( e.contains(itemQuit) ) { System.exit(0); }
		
	}

	@Override
	public void before(GEvent arg0) { }

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		TestForGMenuBarAndGContextFileManagement pan = new TestForGMenuBarAndGContextFileManagement();
		
		GFrame frame = new GFrame("Test GMenuBar", pan, pan.getBar());
		frame.display();

	}

}
