import java.awt.Color;

import org.jfree.data.xy.XYSeries;

import fr.cnes.genius.chart.GFreeChartXY;
import fr.cnes.genius.chart.GFreeChartXY.GSeriesProperties;
import fr.cnes.genius.chart.GShapeFactory;
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFreeChartException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Testing GFreeChartXY with updates.
 * @author goesterjf
 *
 */
public class TestForGFreeChartXYUpdate extends GPanel implements GListener {

	/** entrey for a new abscissa */
	private final GEntryReal newValX;
	/** Plot window */
	private GFreeChartXY plot;
	
	   /** Data stored in series */
    private final XYSeries dataSeries;

	/**
	 * Constructor.
	 * @throws GFreeChartException
	 */
	public TestForGFreeChartXYUpdate() throws GFreeChartException {
		
		// Entry real initialization
		newValX = new GEntryReal("New abscissa to add to the plot:", 0.);
		
		// Plot initialization
		boolean addLegendFlag = true;
		plot = new GFreeChartXY("y = x^2", "x", "y", null, addLegendFlag);
		plot.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(99)));
		plot.setForcedDrawLine(true);
		
		dataSeries = new XYSeries("Square", true);
        final GSeriesProperties prop = new GSeriesProperties(Color.RED, GShapeFactory.createDiamond(3), null, null, null);
        plot.addSerie(false, prop, dataSeries);
		for (int i = 0; i < 5; i++) {
		    dataSeries.add(i, i*i);
		}
		
	}
	
	public void generic() { }

	public void display() throws GException {
		put(newValX);
		put(plot);
	}
	
	@Override
	public void before(GEvent arg0) throws GException {
		// Nothing to do ...
	}

	@Override
	public void after(GEvent arg0) throws GException {
		if ( arg0.contains(newValX)) {
		    dataSeries.add(newValX.getValue(), newValX.getValue()*newValX.getValue());
		}
		
	}

	/**
	 * @param args
	 * @throws GFreeChartException 
	 */
	public static void main(String[] args) throws GFreeChartException {
		TestForGFreeChartXYUpdate pan = new TestForGFreeChartXYUpdate();
		GFrame frame = new GFrame("Plots", pan);	
		frame.display();
	}

}
