import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GArithmeticException;
import fr.cnes.genius.exception.GDateFieldException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryIntVector;
import fr.cnes.genius.highLevel.GEntryRealVector;
import fr.cnes.genius.highLevel.GTable1D;
import fr.cnes.genius.highLevel.GTable1D.TableOrientation;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

public class TestForGEntryVector extends GPanel implements GReadWrite {
    
    private final GEntryIntVector widVecInt;
    private final GEntryRealVector widVecReal;
    
    private final GTable1D widTabI;
    private final GTable1D widTabR;
    
    public TestForGEntryVector () throws GDateFieldException, GArithmeticException {
        
        widVecInt = new GEntryIntVector("vecI", new int[] { 1, 2, 3});
        widVecReal =  new GEntryRealVector("vecR", new double[] {1.1, 2.2, 3.3});
        
        widTabI = new GTable1D("TabI:", TableOrientation.HORIZONTAL, widVecInt);
        widTabR = new GTable1D("TabR:", TableOrientation.HORIZONTAL, widVecReal);
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        
        put(widTabI);
        put(widTabR);
    }

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

    public static void main(String[] args) throws GDateFieldException, GArithmeticException, IOException {
        
      final File refFile = new File("src/test/resources/TestForGEntryVector.xml");
      final File locFile = new File("GEntryVector.xml");
      Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        
      final GPanTest panTest = new GPanTest("GEntryVector", new TestForGEntryVector(),"GEntryVector.xml");
      panTest.display();

        
    }

}
