import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GArithmeticException;
import fr.cnes.genius.exception.GDateFieldException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GChoice;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

public class TestForGEntryReal extends GPanel implements GReadWrite, GListener {
    
    private final GEntryReal real;
    private final GChoice cb;
    
    private enum ValTypes {
        OK,
        NAN,
        POSITIVE_INF,
        NEGATIVE_INF
    }
    
    public TestForGEntryReal () throws GDateFieldException, GArithmeticException {
        
        real  = new GEntryReal("Real:", 0.);
        real.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(false),  GConstraint.width(200)),1);
        try {
            real.addGInterval(new GInterval(0., 3600.));
        } catch ( GIntervalException e ) {
            // Will never occur
        }
        real.setValue(0.);
        
        cb = new GChoice("", "Forced values:", ValTypes.OK);
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        try {
            put(real);
        } catch ( Exception e ) {
            e.printStackTrace();
        }
        put(cb);
    }

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

    @Override
    public void before (GEvent e) throws GException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void after (GEvent e) throws GException {

        if ( e.contains(cb) ) {
            final ValTypes valType = (ValTypes)cb.getValueEnum();
            final double val;
            switch (valType) {
                case NAN:
                    val = Double.NaN;
                    break;
                case POSITIVE_INF:
                    val = Double.POSITIVE_INFINITY;
                    break;
                case NEGATIVE_INF:
                    val = Double.NEGATIVE_INFINITY;
                    break;
                default:
                    val = real.getValue();
                    break;
            }
            try {
                real.setValue(val);
            } catch ( GArithmeticException err ) {
                System.out.println(err.getMessage());
                switch (valType) {
                    case NAN:
                        real.setValue(123456789.);
                        break;
                    case POSITIVE_INF:
                        real.setValue(999999999.);
                        break;
                    case NEGATIVE_INF:
                        real.setValue(-999999999.);
                        break;
                    default:
                        break;
                }
            }
        }
        
    }

    public static void main(String[] args) throws GDateFieldException, GArithmeticException {
        
        final GPanTest panTest = new GPanTest("GEntryReal", new TestForGEntryReal(),"GEntryReal.xml");
        panTest.display();

        
    }

}
