
import java.io.IOException;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryFileName;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

/**
 * Class to define a entry zone for file names giving its relative or absolute names.
 * @author goesterjf
 *
 */
public class TestForGEntryFileName extends GPanel implements GReadWrite {
    
    private final GEntryFileName widAbsName;
    private final GEntryFileName widRelName;
    private final GEntryFileName widFolder;
    private final GEntryFileName widFolderCreate;
    
    public TestForGEntryFileName () {
        
        widAbsName = new GEntryFileName("", false, "Absolute txt names:", "", "absName", 800, "Search for absolute TXT names ...", "absolute names", ".txt");
        widRelName = new GEntryFileName("", true, "Relative xml names:", "", "relName", 700, "Search for relative XML names ...", "relative names", ".xml");
        widFolder = new GEntryFileName("", true, "Folder names:", "", "folder", 700, "Search for relative folder names ...", "relative names", "", false);
        widFolder.setFolderToBeCreated(false);
        widFolderCreate = new GEntryFileName("", true, "Folder names (to be created):", "", "folderCreate", 700, "Search for relative folder names ...", "relative names", "", false);

    }

    @Override
    public void display () throws GException {
        generic();
    }

    @Override
    public void generic () throws GException {
        put(widAbsName);
        put(widRelName);
        put(widFolder);
        put(widFolderCreate);
    }

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

    public static void main (String[] args) throws IOException {
        
        final TestForGEntryFileName test = new TestForGEntryFileName();
        
        final GPanTest panTest = new GPanTest("TestForGEntryFileName", test, "TestForGEntryFileName.xml");
        panTest.display();
        
    }

}
