import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GComboBoxWithLabel;
import fr.cnes.genius.interval.GIntervalAbstract.GStatus;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;

public class TestForGComboBoxWithLabel extends GPanel {
    
    private final GComboBoxWithLabel choiceTest;
    private final GComboBoxWithLabel choiceStatus;
    
    private enum Cases  {
        NONE,
        CASEA,
        CASEB;
    }
    
    public TestForGComboBoxWithLabel() {
        
        choiceTest = new GComboBoxWithLabel("", "Label:", Cases.NONE);
        
        choiceStatus = new GComboBoxWithLabel("", "Label:", GStatus.OK);

    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        
        put(choiceTest);
        if ( (Cases)choiceTest.getValueEnum() == Cases.NONE ) {
            // NONE sends an error
            choiceTest.setForcedStatus(GStatus.ERROR);
        } else {
            choiceTest.setForcedStatus(GStatus.OK);
        }
        choiceTest.updateStatus();
        final GStatus status = choiceTest.getStatus();
        
        put(choiceStatus);
        if ( (GStatus)choiceStatus.getValueEnum() == GStatus.WARN ) {
            if ( status == GStatus.OK ) {
                // We change from OK to WARN
                // else we keep WARN if it was warn or ERROR if it was ERROR
                choiceTest.setForcedStatus(GStatus.WARN);
            }
        } else if ( (GStatus)choiceStatus.getValueEnum() == GStatus.ERROR ) {
            // We force status to ERROR
            choiceTest.setForcedStatus(GStatus.ERROR);
        }
        choiceTest.updateStatus();
        
    }

    public static void main(String[] args) {

        final GFrame frame = new GFrame("TestForGComboBoxWithLabel", new TestForGComboBoxWithLabel());
        frame.setMinimumSize(new Dimension(300, 150));
        frame.display();
        
    }

}
