import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GComboBoxWithLabel;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.interval.GIntervalAbstract.GStatus;
import fr.cnes.genius.lowLevel.GComboBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;

public class TestForGComboBox extends GPanel {
    
    private final GComboBoxWithLabel choiceLabel;
    private final GComboBox choice;
    private final GEntryReal val;
    
    public TestForGComboBox() {
        
        final String[] tabChoice = { "a", "b" };
        choice = new GComboBox("", 0, tabChoice);
        choiceLabel = new GComboBoxWithLabel("Label:", 0, tabChoice);
        
        final GUnit[] unitDis = { new GMetricUnit ("km") , new GMetricUnit ("nmi") };
        val = new GEntryReal("val:", 0., unitDis);
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(choice);
        put(choiceLabel);
        put(val);
        if ( val.getValue() >= 0. ) {
            choice.setForcedStatus(GStatus.OK);
            choiceLabel.setForcedStatus(GStatus.OK);
        } else {
            choice.setForcedStatus(GStatus.ERROR);
            choiceLabel.setForcedStatus(GStatus.ERROR);
        }
        choice.updateStatus();
        choiceLabel.updateStatus();
        
        System.out.println(choice.getStatus());
    }

    public static void main(String[] args) {

        final GFrame frame = new GFrame("TestForGComboBox", new TestForGComboBox());
        frame.display();
        
    }

}
