
import java.awt.Color;
import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GColorChooser;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;

/**
 * Testing r
 * @author goesterjf
 *
 */
public class TestForGColorChooser extends GPanel implements GListener, GReadWrite {
	
    /** Color selector width. */
    private static final int COLOR_SELECTOR_WIDTH = 20;

    /** Maximum height for the color box */
    private static final int COLOR_MAX_HEIGHT = 25;

    private GColorChooser colorChooser;
    	
	public TestForGColorChooser() throws GIntervalException {
	    
	    // GColorChooser initialization
        colorChooser = new GColorChooser(Color.BLUE);
        colorChooser.setConstraint(new GConstraint(GConstraint.wmin(COLOR_SELECTOR_WIDTH),
                GConstraint.height(COLOR_MAX_HEIGHT)));

	}

	public void generic() throws GException {
		put(colorChooser);
	}

    @Override
    public void read () throws GException {
        generic();
    }

    @Override
    public void write () throws GException {
        generic();
    }

	public void display() throws GException {
		generic();
	}
	
    @Override
    public void before(GEvent e) throws GException {
    }

    @Override
    public void after(GEvent e) throws GException {
        
        if ( e.contains(colorChooser) ) {
            final Color color = colorChooser.getColor();
            final float[] cmp = color.getRGBColorComponents(new float[] {0.f, 0.f, 0.f});
            System.out.println(cmp[0] + " " + cmp[1] + " " + cmp[2]);
        }
        
    }
	
	/**
	 * @param args
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
	    
		TestForGColorChooser pan = new TestForGColorChooser();
		GFrame frame = new GFrame("TestForGColorChooser", pan);	
		frame.setPreferredSize(new Dimension(200, 200));
		frame.display();
	}

}
