import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GChoice;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;

public class TestForGChoice extends GPanel {
    
    private final GChoice choice;
    private final GEntryReal val;
    
    public TestForGChoice() {
        
        final String[] tabChoice = { "a", "b" };
        choice = new GChoice("Choice:", 0, tabChoice);
        
        final GUnit[] unitDis = { new GMetricUnit ("km") , new GMetricUnit ("nmi") };
        val = new GEntryReal("val:", 0., unitDis);
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(choice);
        put(val);
    }

    public static void main(String[] args) {

        final GFrame frame = new GFrame("TestForGChoice", new TestForGChoice());
        frame.display();
        
    }

}
