
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.interval.GInterval;
import fr.cnes.genius.interval.GIntervalAbstract.GStatus;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Test for complex status
 * @author goesterjf
 *
 */
public class TestForComplexStatus extends GPanel implements GListener {
	
    private GEntryReal[] vals;
	
	/**
	 * Constructor
	 * @throws GIntervalException 
	 */
	public TestForComplexStatus() throws GIntervalException {
	    vals = new GEntryReal[3];
        vals[0] = new GEntryReal("Real entry 1:", 0.);
        vals[0].addGInterval(new GInterval(0., 1.));
        vals[1] = new GEntryReal("Real entry 2:", 0.);
        vals[1].addGInterval(new GInterval(0., 1.));
        vals[2] = new GEntryReal("Real entry 3:", 0.);
        vals[2].addGInterval(new GInterval(0., 1.));
        testValues();        
	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }

	/**
	 * Display method override.
	 */
	public void display() throws GException {
	    for (int i = 0; i < vals.length; i++) {
    		put(vals[i]);
        }
	}
	
    @Override
    public void after(GEvent arg0) throws GException {

        if ( arg0.contains(vals) ) {
            testValues();
        }
                
    }
    
    private void testValues () {
        double sum = 0.;
        for (int i = 0; i < vals.length; i++) {
            sum = sum + vals[i].getValue();
        }
        if ( sum != 1. ) {
            System.out.println("Not allowed values: sum equals to "+sum);
            for (int i = 0; i < vals.length; i++) {                
                vals[i].setForcedStatus(GStatus.ERROR);
                vals[i].updateStatus();
                vals[i].getGTextField().getJTextField().setToolTipText("Not allowed value: sum equals to "+sum);
            }
        } else {
            for (int i = 0; i < vals.length; i++) {                
                vals[i].setForcedStatus(null);
                vals[i].updateStatus();
            }
        }
    }


    @Override
    public void before(GEvent arg0) throws GException {
    }

	/**
	 * Main method
	 * @param args	no args ...
	 * @throws GIntervalException 
	 */
	public static void main(String[] args) throws GIntervalException {
		TestForComplexStatus pan = new TestForComplexStatus();
		GFrame frame = new GFrame("TestForComplexStatus", pan);	
		frame.display();
	}

}
