
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Test for clear constraints
 * @author goesterjf
 *
 */
public class TestForClearConstraint extends GPanel implements GListener {
	
    private GButton butClear;
    private GButton butAdd;
	private GEntryString str;
	private GEntryInt ent;
	private GEntryReal val;
	private GCheckBox che;
	private GLabel lab;
	
	/**
	 * Constructor
	 */
	public TestForClearConstraint() {
	    
        butClear = new GButton("Clear constraints");
        butAdd = new GButton("Add constraints");
        
		str = new GEntryString("Character string entry:", "text");
		
		ent = new GEntryInt("Integer entry:", 123);
		ent.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(20)), 0, 0);
//        ent.clearInnerDescendantContraint(0, 0);
//        ent.clearAllInnerDescendantConstraint();

		val = new GEntryReal("Real entry:", 99.);
		che = new GCheckBox("Boolean");
		che.setSelected(true);
		lab = new GLabel("This is a label ...");
	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }

	/**
	 * Display method override.
	 */
	public void display() throws GException {
        put(butClear);
        put(butAdd);
		put(str);
		put(ent);
		put(val);
		put(che);
		put(lab);
	}
	
    @Override
    public void after(GEvent arg0) throws GException {

        if ( arg0.contains(butClear) ) {
            ent.clearAllInnerDescendantConstraint();
        }
        
        if ( arg0.contains(butAdd) ) {
            ent.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.gaptop(20)), 0, 0);
       }
        
    }

    @Override
    public void before(GEvent arg0) throws GException {
        // TODO Auto-generated method stub
        
    }

	/**
	 * Main method
	 * @param args	no args ...
	 */
	public static void main(String[] args) {
	    
		TestForClearConstraint pan = new TestForClearConstraint();
		pan.setConstraint(new GConstraint(GConstraint.newline()));
		GFrame frame = new GFrame("TestForClearConstraint", pan);	
		frame.display();
	}

}
