package GTableList;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Testing creation of its own GENIUS object (GTableList with dates inside).
 * @author goesterjf
 *
 */
public class TestForGTableList extends GPanel implements GListener {
    
	private final GTableList table;
	
	private final GLabel lab; // To test the Layout
	private final GCheckBox check; // To test conditional display
	
	public TestForGTableList () {
		
		check = new GCheckBox("Display table");
		check.setSelected(true);
		lab = new GLabel("Label ...");
		
		Calendar calendar = Calendar.getInstance();
//        final ArrayList<Date> dates = new ArrayList<Date>();
//        final ArrayList<Integer> integers = new ArrayList<Integer>();
//        final ArrayList<Double> doubles = new ArrayList<Double>();
        final Object[][] data = new Object[6][3];
		int day = 1;
		for (int i = 0; i < 6; i++) {
    		calendar.set(2015, 0, day++, 1, 10, 30);
//    		  dates.add(calendar.getTime());
//            integers.add(i);
//            doubles.add((double)i);
            data[i][0] = calendar.getTime();
            data[i][1] = i;
            data[i][2] = i + 0.1*i;
        }
		
		String[] titles = { "Date", "Integer", "Real" };
		
		table = new GTableList(data, titles);
		
        table.setColumnSize(0, 200);
        table.setColumnSize(1, 50);
        
        for (int i = 0; i < data.length; i++) {
            table.setCellBackGroundColor(i, 0, Color.YELLOW);
        }
        table.setCellBackGroundColor(1, 1, Color.RED);
        table.setCellBackGroundColor(1, 2, Color.GREEN);
        table.setCellForegGroundColor(2, 1, Color.RED);
        
        table.setColumnAlign(1, XAlign.Center);
        table.setColumnAlign(2, XAlign.Right);
        
        table.setDateFormat(new SimpleDateFormat("dd/mm/yy hh-mm-ss"));
        
	}
		
	@Override
	public void display() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(check);
		put(lab);
		if ( check.isSelected() ) {
			put(table);
		}
	}

	private Object previousObject = null;
	
	@Override
	public void before(GEvent arg0) throws GException {
        if ( arg0.contains(table) ) {
            previousObject = table.getCurrentValue();
        }
	}

	@Override
	public void after(GEvent arg0) throws GException {
		
		if ( arg0.contains(table) ) {
            System.out.println("Data is modified and is equal to " + table.getCurrentValue());
		    if ( previousObject != table.getCurrentValue() ) {
		        System.out.println("Data is modified and is equal to " + table.getCurrentValue());
		    }
		}
	}

	public static void main(String[] args) {

		TestForGTableList test = new TestForGTableList();
		
		GFrame frame = new GFrame("TestForGTableList", test);
		frame.display();

	}

}
