package GTableList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.main.GComponent;
import fr.cnes.genius.main.GDisplay;
import fr.cnes.genius.main.GEvent;


public class GTableList extends GComponent implements GDisplay {
	
	private final JTable      myJTable;
	private final JScrollPane myJScrollPane;
	private final MyModel     myModel;
	
    private final Object[][] data;
    private final Color[][]  bgColorMap;
    private final Color[][]  fgColorMap;
    
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yy hh:mm:ss");

    public GTableList(Object[][] data, String[] columnNames) {
		
		super(null);
		
		this.data = data;
        final int nbRow = data.length;
        this.bgColorMap = new Color[nbRow][];
        this.fgColorMap = new Color[nbRow][];
		for (int i = 0; i < nbRow; i++) {
            this.bgColorMap[i] = new Color[data[i].length];
            this.fgColorMap[i] = new Color[data[i].length];
            for (int j = 0; j < data[i].length; j++) {
                bgColorMap[i][j] = Color.WHITE;
                fgColorMap[i][j] = Color.BLACK;
            }
        }
		
		myModel = new MyModel();
		myModel.addTableModelListener(new TableModelListener() {
            
            @Override
            public void tableChanged (TableModelEvent e) {
                
                GEvent gevent = new GEvent();
                processGEvent(gevent, GTableList.this);
                
            }
            
        });
		
        final MyCellRenderer myCellRenderer = new MyCellRenderer();
		
        myJTable = new JTable(myModel);
        myJTable.setDefaultRenderer(Object.class, myCellRenderer);
        myJTable.setDefaultRenderer(Date.class, myCellRenderer);
        
        for (int i = 0; i < columnNames.length; i++) {
            myJTable.getColumnModel().getColumn(i).setHeaderValue(columnNames[i]);
        }
                
		myJScrollPane = new JScrollPane(myJTable); // To get the column names displayed
		//myJScrollPane.setPreferredSize(new Dimension(150, 200));
		
        final int rowSize = myJTable.getRowHeight();
        final int nbRows = data.length;
        myJTable.setPreferredScrollableViewportSize(new Dimension(300, rowSize*nbRows));
		
	}
	
    @Override
    public void display() {
        doDisplay(this);
    }

    @Override
    public Component getComponent() {
        return myJScrollPane;
    }

    /**
     * @return the myJTable
     */
    public JTable getJTable () {
        return myJTable;
    }

    public Object getValueAt (final int row, final int column) {
        
        return myJTable.getValueAt(row, column);
        
    }
    
    public Object getCurrentValue () {
        
        final int row = myJTable.getSelectedRow();
        final int col = myJTable.getSelectedColumn();
        return myJTable.getValueAt(row, col);
        
    }
    
    public Class<?> getColumnClass(int columnIndex) {
        return getValueAt(0, columnIndex).getClass();
    }
    
    public void setColumnSize(final int numCol, final int colSize) {
        
        myJTable.getColumnModel().getColumn(numCol).setPreferredWidth(colSize);
        
    }
    
    public void setCellBackGroundColor(final int numRow, final int numCol, final Color color) {
        
        bgColorMap[numRow][numCol] =  color;
        
    }
    
    public void setCellForegGroundColor(final int numRow, final int numCol, final Color color) {
        
        fgColorMap[numRow][numCol] =  color;
        
    }
    
    public void setColumnAlign(final int numCol, final XAlign align) {
        
        final int sAlign;
        if ( align == XAlign.Right ) {
            sAlign = SwingConstants.RIGHT;
        } else if ( align == XAlign.Center) {
            sAlign = SwingConstants.CENTER;
        } else {
            sAlign = SwingConstants.LEFT;
        }
        final MyCellRenderer myCellRendererRight = new MyCellRenderer();
        myCellRendererRight.setHorizontalAlignment(sAlign);
        myJTable.getColumnModel().getColumn(numCol).setCellRenderer(myCellRendererRight);
        
    }
    
    public void setDateFormat ( final SimpleDateFormat fmt) {
        
        this.dateFormat = fmt;
        
    }
    
    private class MyModel extends AbstractTableModel {

        private static final long serialVersionUID = 1L;
        
        public MyModel() {
            
        }
        
        public boolean isCellEditable(int row, int col) {
            return true;
        }
        
        @Override
        public int getRowCount () {
            return data.length;
        }

        @Override
        public int getColumnCount () {
            return data[0].length;
        }

        @Override
        public Object getValueAt (int rowIndex, int columnIndex) {
            return data[rowIndex][columnIndex];
        }

        public Class<?> getColumnClass(int columnIndex) {
            return getValueAt(0, columnIndex).getClass();
        }
        
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            data[rowIndex][columnIndex] = value;
            fireTableCellUpdated(rowIndex, columnIndex);
        }

    }
      
    private class MyCellRenderer extends DefaultTableCellRenderer {
        
        private static final long serialVersionUID = 1L;

        public MyCellRenderer () {
            
        }
        
        @Override
        public Component getTableCellRendererComponent (final JTable table, Object value,
            final boolean isSelected, final boolean hasFocus, final int row,final int column) {
            
            if( value instanceof java.util.Date) {
                value = dateFormat.format(value);
            }

            final Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            
            cell.setBackground(bgColorMap[row][column]);
            cell.setForeground(fgColorMap[row][column]);
            
            return cell;
        }
        
    }
    
}
