package GTabbedPaneAndUpdate;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

/**
 * Testing GTabbedPane update as well as Observer/Observable functionality.
 * @author goesterjf
 *
 */
public class TestForGTabbedPaneAndUpdate extends GPanel implements GReadWrite {
	
	/** Tabbedpane */
	private AppliTabbedPane tabs;
	
	/**
	 * Constructor.
	 * By default, we start with four standard panes.
	 * @throws GException
	 */
	public TestForGTabbedPaneAndUpdate () throws GException {
		
		final int nbTabs = 4;		
		tabs = new AppliTabbedPane(nbTabs);
		tabs.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.grow(), GConstraint.push()));

	}

	public void display() throws GException {
		generic();
		}

	@Override
	public void generic() throws GException {
        put(tabs.getPan0());
        put(tabs);
	}
	
	public void read() throws GException {
		generic();
		}

	public void write() throws GException {
		generic();
		}

	public static void main(String[] args) throws GException, IOException {

        final File refFile = new File("src/test/resources/TestForGTabbedPaneAndUpdate.xml");
        final File locFile = new File("TestForGTabbedPaneAndUpdate.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

		TestForGTabbedPaneAndUpdate test = new TestForGTabbedPaneAndUpdate();

		GPanTest panTest = new GPanTest("TestForGTabbedPaneAndUpdate", test, "TestForGTabbedPaneAndUpdate.xml");
		panTest.getJFrame().setPreferredSize(new Dimension(750, 450));

		panTest.display();

	}

}
