package GTabbedPaneAndUpdate;

import java.util.ArrayList;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GTabbedPane;

/**
 * Tabbed pane including:
 * - an AppliPan0
 * - zero to several AppliPanStd panes depending on what has been entered in AppliPan0.
 * @author goesterjf
 *
 */
public class AppliTabbedPane extends GTabbedPane  {

	/** pan0 (see its definition ...) */
	private AppliPan0 pan0;
	/** List of standard pans */
	private ArrayList<AppliPanStd> listOfpans;
	
	/**
	 * Constructor
	 * @param nbTabs		Initial amount of tabs
	 * @throws GException	GENIUS exception
	 */
	public AppliTabbedPane( final int nbTabs ) throws GException {
		
		// Name of the top level data structure
		super("data");
		
		// First pan where the amount of following pans is defined + common real value for all pans
		pan0 = new AppliPan0(nbTabs, this);
		
		// List of following pans
		listOfpans = new ArrayList<AppliPanStd>();
		for (int i = 0; i < nbTabs; i++) {
			listOfpans.add(new AppliPanStd());
			// pan0 will be observed by listOfpans.get(i)
			pan0.registerObserver(listOfpans.get(i));
			this.addTab("Tab "+(i+1), listOfpans.get(i));
		}
		
	}
	
	/**
	 * Method to manage the amount of tabs
	 * @param nbStdPans		Amount of std panels
	 * @throws GException	GENIUS exception
	 */
	public void manageAmountOfPans ( final int nbStdPans ) throws GException {
	
		final int currentNumTabs = this.getTabCount();
        final int numTabs = nbStdPans;
        
		if ( nbStdPans <  currentNumTabs ) {
			// Case we have to remove tabs
			for (int index = (currentNumTabs-1) ; index >= numTabs; index--) {
				// We delete the pan
				this.delTab(index);
				// No more observation because pan has been removed
				pan0.unregisterObserver(listOfpans.get(index-1));
				// We remove the panel of the list
				listOfpans.remove(index-1);
			}
		} else if ( nbStdPans > currentNumTabs ) {
			// Case we have to add tabs
			for (int index = currentNumTabs+1 ; index <= numTabs; index++) {
                final AppliPanStd newPanel = new AppliPanStd();
				listOfpans.add(newPanel);
				// pan0 will be observed by listOfpans.get(i)
				pan0.registerObserver(newPanel);
				this.addTab("Tab "+index, newPanel);
			}
		}
	
	}
	
	/**
	 * Getting the pan0
	 * @return pan0
	 */
	public AppliPan0 getPan0() {
		return pan0;
	}
	
}
