package GStandardApplication.ihm;

import GStandardApplication.calc.Vehicle;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GBufferedTextArea;
import fr.cnes.genius.standardapplication.GDataPanelAbstract;

/**
 * Class regrouping all data/main widgets that will be set in Tabbed panes.
 * That will allow to manage more easily the read/write configurations.
 * @author goesterjf
 *
 */
public class WidSWDataPanel extends GDataPanelAbstract {
    
    private final WidVehicle widVehicle;
        
    /**
     * Constructor.
     * @throws GException   GENIUS exception
     */
    public WidSWDataPanel () throws GException {
        
    	// Calling for the super constructor
    	// "Data" is the name of the root XML name for the context files
        super("Data", GDataPanelAbstract.ConsoleModeType.Buffer);
        ((GBufferedTextArea)this.getConsole()).setLines(100, 10);
        
        // Creating a vehicle data widget 
        widVehicle =  new WidVehicle();
        // Adding it in a tabbedpane
        this.addTab("Vehicle", widVehicle);
        
        // Adding an output console
        this.addConsoleTab("Output");
                
    }
    
    /**
     * Method returning a vehicle object needed by the application.
     * @return  object vehicle
     */
    public Vehicle getVehicle () {
        return widVehicle.getCalcObject();
    }

    
    /**
     * Overriding the display method.
     */
    @Override
    public void display () throws GException {
        super.display();
    }

    /**
     * Overriding the clear method.
     */
	@Override
	public void clear() throws GException {
	}

}
