package GList;

import java.util.ArrayList;

import javax.swing.JList;
import javax.swing.ListSelectionModel;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GList;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.utils.GPanTest;

public class GListTest extends GPanel implements GListener {
    
    private final GList list;
    private final GButton button;

    public GListTest( final ArrayList<String> listOfData ) {

        list = new GList(listOfData);
        list.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        list.setLayoutOrientation(JList.VERTICAL_WRAP);
        list.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.width(300)));

        button = new GButton("Display selected files ...");

    }

    @Override
    public void display() throws GException {
        generic();
    }
   
    @Override
    public void generic() throws GException {
        put(button);
        put(list);
    }

    @Override
    public void before(GEvent e) throws GException {
        // TODO Auto-generated method stub
    }

    @Override
    public void after(GEvent e) throws GException {

        if ( e.contains(button)) {
            System.out.println(list.getSelectedValues());
        }
        
    }
 
    /**
     * @param args
     */
    public static void main(String[] args) {

        final int dim = 30;
        final ArrayList<String> listOfData = new ArrayList<>();
        for (int i = 0; i < dim; i++) {
            listOfData.add("File"+i+".txt  ");
        }
        GListTest list = new GListTest(listOfData);
        GPanTest test = new GPanTest("Test GList", list);
        test.display();

    }

}
