package GFrameExit;
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GDialog;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Exit dialog.
 * @author goesterjf
 *
 */
public class TestForFrameExitDialog extends GDialog implements GListener {
	
	private GLabel lab;
	private GButton yes;
	private GButton no;
	
	private boolean exit;
	
	public TestForFrameExitDialog( String title ) {
		
		super(title);
		
		lab = new GLabel("Do you want to quit ?");
		lab.setConstraint(new GConstraint(GConstraint.gapbottom(20)));
		
		yes = new GButton("Yes");
		no  = new GButton("No");
		no.setConstraint(new GConstraint(GConstraint.newline(false)));
		
	}
	
	@Override
	public void display() throws GException {
		generic();
	}
	
	@Override
	public void generic() throws GException {
		put(lab);
		put(yes);
		put(no);
	}

	@Override
	public void before(GEvent arg0) throws GException {
	}

	@Override
	public void after(GEvent arg0) throws GException {
		
		if ( arg0.contains(yes) ) {
			exit = true;
		}
		if ( arg0.contains(no) ) {
			exit = false;
		}
		this.dispose();
		
	}

	public boolean isExit() {
		return exit;
	}

}
