package GDialogAndGDetachedPanel;
import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.utils.GPanTest;

/**
 * Testing GDialog and GDetachedPanel widgets.
 * @author goesterjf
 *
 */
public class TestForGDialogAndGDetachedPanel extends GPanel {
	
	private GCheckBox cbDialog;
	private GCheckBox cbDetach;
	private GDialogWidget dialog;
	private GDetachedPanelWidget detach;
	
	public TestForGDialogAndGDetachedPanel() {
		
		cbDetach = new GCheckBox("Test GDetachedPanel");
		cbDialog = new GCheckBox("Test GDialog");
		
		detach = new GDetachedPanelWidget("GDetachedPanel");
		dialog = new GDialogWidget("GDialog");
		dialog.setMinimumSize(new Dimension(150, 150));

	}

	@Override
	public void display() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(cbDetach);
		if ( cbDetach.isSelected() ) {
			put(detach);
		}
		put(cbDialog);
		if ( cbDialog.isSelected() ) {
			dialog.show();
			cbDialog.setSelected(false);
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {


		TestForGDialogAndGDetachedPanel test = new TestForGDialogAndGDetachedPanel();
		GPanTest pan = new GPanTest("Test For GDialog and GDetachedPanel", test);
		pan.display();
	}

}
