package GDialogAndGDetachedPanel;
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GCheckBox;
import fr.cnes.genius.lowLevel.GDialog;
import fr.cnes.genius.lowLevel.GLabel;

/**
 * GDialog widget
 * @author goesterjf
 *
 */
public class GDialogWidget extends GDialog {
	
	private GCheckBox cb;
	private GLabel lab;
	
	public GDialogWidget( String title ) {
		
		super(title);
		
		cb = new GCheckBox("Display label");
		
		lab = new GLabel("GDialog test ...");
		lab.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.gap(0, 0, 50, 50)));
		
		this.setConstraint(new GConstraint(GConstraint.height(250), GConstraint.width(150)));
		this.setConstraint(new GConstraint(GConstraint.hmin(250), GConstraint.wmin(150)));
		this.setConstraint(new GConstraint(GConstraint.hmax(250), GConstraint.wmax(150)));
		
		this.setHorizontalScroll(ScrollBarVisibility.AS_NEEDED);
		this.setVerticalScroll(ScrollBarVisibility.AS_NEEDED);
		
	}
	
	@Override
	public void display() throws GException {
		generic();
	}
	
	@Override
	public void generic() throws GException {
		put(cb);
		if ( cb.isSelected() ) put(lab);
	}

}
