package GComponentList;
import java.util.logging.Level;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.loggers.GConsoleLogger;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;

/**
 * Class to test reading of heavy files.
 * @author goesterjf
 *
 */
public class TestForReadingHeavyContext extends GPanel implements GListener {
    
    private final GButton load;
    private final GButton save;
    private final GComponentList list;
    
    public TestForReadingHeavyContext() {
        
        load = new GButton("Load");
        load.setConstraint(new GConstraint(GConstraint.split(2)));
        save = new GButton("Save");
        save.setConstraint(new GConstraint(GConstraint.newline(false)));
        
        list = new GComponentList("Test", TestForGComponentListWidget.class, false);
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(load);
        put(save);
        put(list);
    }

    @Override
    public void before(GEvent arg0) throws GException {
        // TODO Auto-generated method stub
    }

    @Override
    public void after(GEvent arg0) throws GException {

        if ( arg0.contains(load) ) {
            System.out.println("Loading data ...");
            GConsoleLogger.getLogger().log(Level.INFO, "Start loading data ...");
            GFileManipulation.readConfig("src/test/resources/TestForReadingHeavyContext.xml", "data", list, false);
            GConsoleLogger.getLogger().log(Level.INFO, "Finish loading data ...");
        }

        if ( arg0.contains(save) ) {
            System.out.println("Saving data ...");
            GFileManipulation.writeConfig("TestForReadingHeavyContext.xml", "data", list, false);
        }

    }

    public static void main(String[] args) {
        
        final GFrame frame = new GFrame("TestForReadingHeavyContext", new TestForReadingHeavyContext());
        frame.display();

    }

}
