package GComponentList;
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.highLevel.GEntryString;
import fr.cnes.genius.lowLevel.GImage;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;


/**
 * Basic widget used for TestForGComponentList
 * @author goesterjf
 *
 */
public class TestForGComponentListWidget extends GPanel implements GReadWrite, Cloneable {
	
	GEntryString widget1;
	GEntryInt widget2;
	GEntryReal widget3;
	GImage image;
	GImage sphere = new GImage("/images/Sphere.png");
	
	public TestForGComponentListWidget ( String text, int valI, double valD, GImage image ) {
		
		init(text, valI, valD, image);

	}

	public TestForGComponentListWidget () {
		
		init("tmp", 0, 0., new GImage("/images/Sphere.png"));

	}
	
	private void init ( String text, int valI, double valD, GImage image ) {
		
		widget1 = new GEntryString("Text", text);
		widget2 = new GEntryInt("Integer", valI);
		widget3 = new GEntryReal("Double", valD);
		this.image = image;
		image.setConstraint(new GConstraint(GConstraint.gapleft(50)));
		
	}

	public void generic() throws GException {
		//beginOfElement("test");
			put(widget1);
	        put(image);
			put(widget2);
			put(widget3);
		//endOfElement();
	}

	public void read() throws GException { generic(); }

	public void write() throws GException { generic(); }

	public void display() throws GException {
        put(widget1);
        put(image);
        put(widget2);
        put(widget3);
	    }
	
	public TestForGComponentListWidget clone () throws CloneNotSupportedException {
		return new TestForGComponentListWidget(this.widget1.getValue(), this.widget2.getValue(), this.widget3.getValue(), sphere);
	}

	public String getString()  {
		return widget1.getValue();
	}

	public int getInt()  {
		return widget2.getValue();
	}

	public double getReal()  {
		return widget3.getValue();
	}
	
	public void setEnabled ( boolean flag ) {
		widget1.setEnabled(flag);
		widget2.setEnabled(flag);
		widget3.setEnabled(flag);
	}

}
