package GComponentList;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;

/**
 * Test for class GComponentList
 * @author goesterjf
 *
 */
public class TestForGComponentListBugRemove extends GPanel implements GReadWrite {
	
	private GComponentList test;
	
	public TestForGComponentListBugRemove () {
		
        this.test = new GComponentList("Test", TestForGComponentListWidget.class, true);
        this.test.setMinMaxElementNumber(2, 10);
		
	}
	
	@Override
	public void display() throws GException {
		generic();
	}
	
	@Override
	public void read() throws GException {
		generic();
	}

	@Override
	public void write() throws GException {
		generic();
	}

	@Override
	public void generic() throws GException {
		put(test);
	}

	/**
	 * @param args
	 * @throws GFileManipulatorException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws GFileManipulatorException, IOException {

        final File refFile = new File("src/test/resources/TestForGComponentListBugRemove.xml");
        final File locFile = new File("TestForGComponentListBugRemove.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        final GPanTest frame = new GPanTest("TestForGComponentListBugRemove", new TestForGComponentListBugRemove(), "TestForGComponentListBugRemove.xml");
		frame.setPreferredSize(new Dimension(800, 750));
		frame.display();

	}

}
