package GComponentList;

import java.awt.Dimension;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.highLevel.GComponentList;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GClear;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;

/**
 * Test for class GComponentList
 * @author goesterjf
 *
 */
public class TestForGComponentListBug extends GPanel implements GClear, GListener {
	
    private final GLabel label;
	private final GComponentList test;
	
	public TestForGComponentListBug () {
		
	    this.label = new GLabel("List:");
	    this.label.attachCopyPasteMenu(null, CopyPasteOperation.All);
		this.test = new GComponentList("List:", GEntryReal.class, true);
		
	}
	
	@Override
	public void display() throws GException {
		generic();
	}
	
	@Override
	public void generic() throws GException {
        put(label);
        put(test);
	}

    @Override
    public void clear () throws GException {
        generic();
        test.setList(null);
        
    }

    @Override
    public void before (GEvent e) throws GException {
        // Nothing to do
    }

    @Override
    public void after (GEvent e) throws GException {
        handleCopyPasteEvent(label, e);        
    }

	/**
	 * @param args
	 * @throws GFileManipulatorException 
	 */
	public static void main(String[] args) throws GFileManipulatorException {

		final GFrame frame = new GFrame("Test GComponentListBug", new TestForGComponentListBug());
		frame.setPreferredSize(new Dimension(600, 300));
		frame.display();
		
	}

}
