package Ex6.ihm;
import java.awt.Dimension;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.constraints.GConstraint.XAlign;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genius.exception.GIntervalException;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GFileManipulation;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.threads.GCommandLauncher.GExecButton;
import fr.cnes.genius.threads.GCommandLauncher.ProcessStatus;
import fr.cnes.genius.threads.GJavaCommandLauncher;

/**
 * Exercise #6
 * @author goesterjf
 *
 */
public class GEx6Panel extends GPanel implements GListener, GReadWrite {
	
	private GButton butLoad;
	private GButton butSave;
	private GButton butQuit;

	private GScenario sceIhm;
	
	private GJavaCommandLauncher cmd;
	private GExecButton butExec;
	
	/**
	 * Constructor.
	 * @throws GIntervalException
	 */
	public GEx6Panel() throws GIntervalException {
		
		String path = System.getProperty("java.class.path");
		cmd = new GJavaCommandLauncher(null, path, "Launch computation", "Stop computation", null);
		cmd.setJavaCommand(path, new String[] {"Ex6.ihm.Batch", "dataTmp.xml"});
		// To assign the process output towards the standard output
		cmd.setCopyOutputToStdout(true);
		butExec= cmd.getGExecButton();
		
		butLoad = new GButton("Load");
		butLoad.setConstraint(new GConstraint(GConstraint.split(3)));
		butSave = new GButton("Save");
		butSave.setConstraint(null);
		butExec.setConstraint(null);
		butQuit = new GButton("Quit");
		butQuit.setConstraint(new GConstraint(GConstraint.skip(1), GConstraint.alignx(XAlign.Right), GConstraint.growx()));

		sceIhm = new GScenario();
		sceIhm.setConstraint(new GConstraint(GConstraint.newline(true, 20), GConstraint.spanx(99), GConstraint.grow(), GConstraint.push()));
		
	}

	/**
	 * Before method override.
	 */
	public void before(GEvent e) throws GFileManipulatorException {
		
		if ( e.contains(butExec) ) {
			if ( (! cmd.isRunning()) ) {
				if ( sceIhm.getScenario().size() > 0 ) {
					System.out.println("Writing data ...");
					GFileManipulation.writeConfig("dataTmp.xml", "Data", sceIhm, false);
					System.out.println("Computation started ...");
				}
				else {
					System.out.println("Computation cancelled ...");
					cmd.setInhibited(true);
				}
			}
		}
		
	}

	/**
	 * After method override.
	 */
	public void after(GEvent e) throws GFileManipulatorException {
		
		if ( e.contains(butQuit) )	{ System.exit(0); }
		
		if ( e.contains(butLoad) )	{ GFileManipulation.readConfig("ExData/data6.xml", "Data", sceIhm, false); }
		
		if ( e.contains(butSave) ) { GFileManipulation.writeConfig("ExData/data6.xml", "Data", sceIhm, true); }

		if ( (e.getFinalSource() == cmd) ) { 
			// Application has been launched
			if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_NORMALY ) {
				System.out.println("Computation nominally stopped ...");
			}
			else if ( cmd.getProcessStatus() == ProcessStatus.FINISHED_BY_USER ) {
				System.out.println("Computation stopped by user ...");
			}
		}
		
	}

	/**
	 * Generic method override.
	 */
	public void generic() throws GException {
		put(cmd);
		put(butLoad);
		put(butSave);
		put(butExec);
		put(butQuit);
		put(sceIhm);		
	}

	/**
	 * Display method : only use generic one.
	 */
	public void display() throws GException { generic(); }

	/**
	 * Read method : only use generic one.
	 */
	public void read() throws GException { generic(); }

	/**
	 * Write method : only use generic one.
	 */
	public void write() throws GException { generic(); }
	
	/**
	 * @param args	no args ...
	 * @throws GIntervalException
	 */
	public static void main(String[] args) throws GIntervalException {
		
		GEx6Panel pan = new GEx6Panel();
		
		GFrame frame = new GFrame("GEx6", pan);
		frame.setMinimumSize(new Dimension(600, 500));
		
		frame.display();

	}

}
