package Ex5.ihm;
import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GChoice;
import fr.cnes.genius.lowLevel.GLabel;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.lowLevel.GSeparator;
import fr.cnes.genius.main.GReadWrite;

/**
 * Class defining maneuver scenario widget
 * @author goesterjf
 *
 */
public class GScenario extends GPanel implements GReadWrite {
	
	private static final int NB_PROP_MAX = 5;
	
	/** GChoice widget to be able to choose the amount of maneuvers */
	private GChoice nbPropu;
	/** Table of separator lines */
	private GSeparator[] sepIhm =  new GSeparator[NB_PROP_MAX];
	/** Table of maneuver widgets */
	private GManeuver[] manIhm =  new GManeuver[NB_PROP_MAX];
	/** Table of labels */
	private GLabel[] label = new GLabel[NB_PROP_MAX];
	
	/**
	 * Constructor.
	 */
	public GScenario() {
		
		String[] choix = new String[NB_PROP_MAX+1];
		choix[0] = "0"; // We must not forget the "0 choice !

		// We create all the possible widgets (even if they will not be displayed)
		for (int i = 0; i < NB_PROP_MAX; i++) {
			choix[i+1] = Integer.toString(i+1);
			sepIhm [i] = new GSeparator(GSeparator.HORIZONTAL);
			sepIhm [i].setConstraint(new GConstraint(GConstraint.newline(true, 20), GConstraint.width(150)));
			label [i] = new GLabel("Thrust number "+(i+1)+":");
			manIhm [i] = new GManeuver();
		}
		
		nbPropu = new GChoice("Amount of maneuvers:", 0, choix);
		nbPropu.setNameInConfigFile("nbp");		
		nbPropu.setInnerDescendantConstraint(new GConstraint(GConstraint.split(6), GConstraint.spanx(2)), 1);
		
	}

	/**
	 * Generic method override.
	 */
	public void generic() throws GException {	
		put(nbPropu);
		if ( nbPropu.getValue() > 0 ) {
			for (int i = 1; i <= nbPropu.getValue(); i++) {
				// Opening structure data
				beginOfElement(ItemTypePlus.Maneuver, "Thrust_"+i);
				put(sepIhm[i-1]);
				put(label[i-1]);
				put(manIhm[i-1]);
				// Closing structure data
				endOfElement();
			}
		}
	}

	/**
	 * Display method : only use generic one.
	 */
	public void display() throws GException { generic(); }

	/**
	 * Read method : only use generic one.
	 */
	public void read() throws GException { generic(); }

	/**
	 * Write method : only use generic one.
	 */
	public void write() throws GException { generic(); }

}
