package Ex5.ihm;

import Ex5.calc.Maneuver;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GEntryReal;
import fr.cnes.genius.lowLevel.GContainer;
import fr.cnes.genius.main.GDisplay;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.utils.GPanTest;

/**
 * Class defining the maneuver widget
 * @author goesterjf
 *
 */
public class GManeuver extends GContainer implements GDisplay, GReadWrite {
		
	/** Maneuver duration widget */
	private GEntryReal durationIhm;
	/** Maneuver thrust level widget */
	private GEntryReal thrustIhm;
	/** Maneuver specific impulse widget */
	private GEntryReal ispIhm;
	
	// Units
	private GUnit[] unitDuration = {new GMetricUnit("mn"), new GMetricUnit("s")};
	private GUnit[] unitThrust = {new GMetricUnit("N")};
	private GUnit[] unitIsp = {new GMetricUnit("s")};
	
	/**
	 * Constructor with no arguments
	 */
	public GManeuver ( ) {

		this(new Maneuver(0., 0., 0.));

	}
	
	/**
	 * Constructor with maneuver object as entry data
	 * @param man   maneuver object
	 */
	public GManeuver ( Maneuver man ) {

		durationIhm =  new GEntryReal("Duration :", man.getDuration(), unitDuration);
		durationIhm.setNameInConfigFile("duration");
		thrustIhm =  new GEntryReal("Thrust :", man.getThrust(), unitThrust);
		thrustIhm.setNameInConfigFile("thrust");
		ispIhm = new GEntryReal("Isp :", man.getIsp(), unitIsp);
		ispIhm.setNameInConfigFile("isp");

	}

	/**
	 * Generic method override.
	 */
	public void generic() throws GException {
		put(durationIhm);
		put(thrustIhm);
		put(ispIhm);
	}

	/**
	 * Display method : only use generic one.
	 */
	public void display() throws GException {
		generic();
	}
	
	/**
	 * Read method : only use generic one.
	 */
	@Override
	public void read() throws GException {
		generic();
	}

	/**
	 * Write method : only use generic one.
	 */
	@Override
	public void write() throws GException {
		generic();
	}

	/**
	 * Method giving a Maneuver object.
	 * @return	maneuver object
	 */
	public Maneuver getManeuver () {
		return new Maneuver(durationIhm.getValue(), thrustIhm.getValue(), ispIhm.getValue());
	}

	/**
	 * Executable method to test the widget unitarily
	 * @param args   no args ...
	 */
	public static void main(String[] args) {
		GManeuver man = new GManeuver(new Maneuver(0., 0., 0.));
		GPanTest testMan = new GPanTest("Test GManoeuvre", man, "man.xml");
		testMan.display();
	}

}
