package Ex3;
import java.awt.Dimension;
import java.awt.Font;
import java.io.UnsupportedEncodingException;

import javax.swing.JOptionPane;

import fr.cnes.genius.constraints.GConstraint;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.highLevel.GConsole;
import fr.cnes.genius.highLevel.GEntryInt;
import fr.cnes.genius.lowLevel.GButton;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;


/**
 * Exercise #3
 * @author goesterjf
 *
 */public class Gex3Panel extends GPanel implements GListener {
		
	private GButton butQuit;
	private GButton butInfo;
	private GButton butComm;
	
	private GEntryInt integer;
	
	private GConsole console;
	
	private int oldInt; // Integer to keep in memory the old value
	
	/**
	 * Constructor.
	 * @throws UnsupportedEncodingException
	 */
	public Gex3Panel() throws UnsupportedEncodingException {
		
		butQuit = new GButton("Quit");
		// Quit & next Infobutton will be in the same cell
		butQuit.setConstraint(new GConstraint(GConstraint.split(2)));
		
		butInfo = new GButton("Infos");
		// Staying on the same line + 5 pixel gap
		butInfo.setConstraint(new GConstraint(GConstraint.newline(false), GConstraint.gapleft(5)));
		
		butComm = new GButton("Comment");
		// On a new line + 50 pixels height
		butComm.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.height(50)));
		
		integer = new GEntryInt("Integer input:", 0);
		// Newline + 50 pixels width
		integer.setInnerDescendantConstraint(new GConstraint(GConstraint.newline(), GConstraint.width(50)), 0, 0);
		integer.setInnerDescendantConstraint(new GConstraint(GConstraint.width(50)), 1);

		console = new GConsole();
		// Setting the font by using a direct swing method
		console.getJTextArea().setFont(new Font("Courier", Font.PLAIN, 12));
		// Standard output is redirected towards this console
		console.redirectSystemStreams(true, false);
		
		// Newline + occupying the rest of the frame
		console.setConstraint(new GConstraint(GConstraint.newline(), GConstraint.spanx(99), GConstraint.push(), GConstraint.grow()));

	}

	/**
	 * Nothing with generic as we only use display ...
	 */
	public void generic() { }
	
	/**
	 * Display method override.
	 */
	public void display() throws GException {
		put(butQuit);
		put(butInfo);
		if ( integer.getValue() != 0 ) put(butComm);	
		put(integer);
		put(console);		
	}
	
	/**
	 * Before method override.
	 */
	public void before(GEvent e) { 
		if ( e.contains(integer) ) {
			oldInt = integer.getValue();
		}
	}

	/**
	 * After method override.
	 */
	public void after(GEvent e) {
		
		if ( e.contains(butQuit) ) { System.exit(0); }
		if ( e.contains(butInfo)  ) { JOptionPane.showMessageDialog(null, "GENIUS\nEXERCICE 3"); }
		if ( e.contains(butComm)  ) { System.out.println("Hello"); }
		if ( e.contains(integer)  )  {
			System.out.println("Entry data: " + integer.getValue());
			if ( integer.getValue() < 0 ) {
				System.out.println("Warning, this value may not be negative ...");
				// We recover the old value
				integer.setValue(oldInt);
				}
			}

	}

	/**
	 * Main method
	 * @param args	no args ...
	 */
	public static void main(String[] args) throws UnsupportedEncodingException {
		Gex3Panel pan = new Gex3Panel();
		GFrame frame = new GFrame("GEx3", pan);
		frame.setPreferredSize(new Dimension(400, 500));
		frame.display();
	}

}
